#ifndef _GERESOURCE_H
#define _GERESOURCE_H

#ifndef __API_INTERN__
	#include "ge_math.h"
	#include "c4d_string.h"
	#include "c4d_file.h"
#else
	#include "ge_math.h"
	#include "ge_string.h"
#endif

class Filename;

class GeResource
{
	private:
		class LocalResource *lr;
		Bool state,glob;
		Filename *initfn;

	public:
		GeResource(void);
		~GeResource(void);

		Bool   Init(void);
		Bool   Init(const Filename &path);
		Bool	 InitAsGlobal(void);
		const String &LoadString(LONG id);
		Bool   Flush(void);
		void   Free(void);

		LocalResource *Get() { return lr; }
};

const String &GeLoadString(LONG id);
String GeLoadString(LONG id, const String &p1);
String GeLoadString(LONG id, const String &p1, const String &p2);
String GeLoadString(LONG id, const String &p1, const String &p2, const String &p3);
String GeLoadString(LONG id, const String &p1, const String &p2, const String &p3,const String &p4);

Bool RegisterDescription(LONG id, const String &idstr, LocalResource *res=NULL);

extern GeResource resource;

#endif
